import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create figure and axis
fig, ax = plt.subplots(figsize=(12, 6))

# Define colors
clear_color = 'green'
blocked_color = 'red'
text_color = 'black'

# Define curbs and cars
curbs = [
    {'id': 'curb_0', 'cars': ['car6', 'car7'], 'status': 'blocked'},
    {'id': 'curb_1', 'cars': ['car1', 'car8'], 'status': 'blocked'},
    {'id': 'curb_2', 'cars': ['car9', 'car4'], 'status': 'blocked'},
    {'id': 'curb_3', 'cars': ['car3'], 'status': 'clear'},
    {'id': 'curb_4', 'cars': ['car0'], 'status': 'clear'},
    {'id': 'curb_5', 'cars': ['car5'], 'status': 'clear'},
    {'id': 'curb_6', 'cars': ['car2'], 'status': 'clear'}
]

# Draw curbs and cars
for i, curb in enumerate(curbs):
    # Draw curb
    curb_color = blocked_color if curb['status'] == 'blocked' else clear_color
    rect = patches.Rectangle((i * 2, 2), 1.5, 1, linewidth=1, edgecolor='black', facecolor=curb_color)
    ax.add_patch(rect)
    ax.text(i * 2 + 0.75, 2.5, f"{curb['id']}\n{curb['status']}", color=text_color, ha='center', va='center')

    # Draw cars
    for j, car in enumerate(curb['cars']):
        car_color = clear_color if j == 1 else blocked_color
        circle = patches.Circle((i * 2 + 0.75, 1 - j * 0.5), 0.3, linewidth=1, edgecolor='black', facecolor=car_color)
        ax.add_patch(circle)
        ax.text(i * 2 + 0.75, 1 - j * 0.5, f"{car}", color=text_color, ha='center', va='center')

# Create legend
legend_patches = [
    patches.Patch(color=clear_color, label='Clear'),
    patches.Patch(color=blocked_color, label='Blocked')
]
ax.legend(handles=legend_patches, loc='upper right')

# Set limits and hide axes
ax.set_xlim(-1, 15)
ax.set_ylim(-1, 3)
ax.axis('off')

# Save the figure
plt.savefig('parking/one_shot/ini_diagram_code/attempts/attempt_12.png')
plt.show()